/*! \file 
**********************************************************************************	
* Title:						Discretix NVS Debug Header File						 					
*																			
* Filename:						nvs_debug.h 															
*																			
* Project, Target, subsystem:	NVS, Debug 
* 
* Created:						17.07.2007														
*
* Modified:						17.07.2007										
*
* \Author						Miri S														
*																			
* \Remarks						Copyright (C) 2008 by Discretix Technologies Ltd.     			
*  								All Rights reserved											
**********************************************************************************/
#ifndef _DX_NVS_DEBUG_H_
    #define _DX_NVS_DEBUG_H_
#ifdef __cplusplus
extern "C" {
#endif


//#define NVS_DEBUG_MODE_ENABLED

/*----------- Includes ----------------------------------------*/
#include "nvs_debug_def.h"
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Stdio.h"
#include "DX_VOS_Mem.h"
//#include "DX_VOS_Sem.h"


#ifdef NVS_DEBUG_MODE_ENABLED

/*----------- Global type definitions ----------------------------------------*/
typedef enum
{
    NVS_DBG_OP_READ,
    NVS_DBG_OP_WRITE,
    NVS_DBG_OP_BOTH

}NVSDebugOpType_t;

typedef struct  
{
    /* Is the NVS debug module active */
    DxBool_t isActive;

    /* The error to be returned */
    DxError_t nvsErrorToReturn;

    /* When the <accessToFail> is reached the NVS will return <nvsErrorToReturn> */
    DxUint32_t accessToFail;

    /* Counts the NVS accesses in this session */
    DxUint32_t accessCurrent;

    /* NVS op type to fail */
    NVSDebugOpType_t opTypeToFail;

    /* Log file to be used for error reports */
    DxVosFile     logFileHandle;

    /* Total Number of writes performed in this debug session */
    DxUint32_t writeOpCount;

    /* Total Number of reads performed in this debug session */
    DxUint32_t readOpCount;

    /*indicates if NVS err was called*/
    DxBool_t NVSErrorWasCalld;


} NVSDebugParams_t;



/*----------- Global function prototypes -------------------------------------*/

/*!
\brief 
Commence the debug session.
After this API will return, the NVS will fail with error <aErrorToReturn>
on the <aAccessToFail>'th access.
If aAccessToFail == 0, the NVS will never fail.
The user can choose the type of the operation to fail using aOpTypeToFail (read / write / both).
@param  aErrorToReturn	[in]	error that will return from NVS
@param  aAccessToFail   [in]    index to fail in NVS
@param  aOpTypeToFail   [in]    type of the operation to fail (read / write / both)
@param  aLogFileHandle  [in]    file to print into
@return DX_SUCCESS		On success
@return	DX_FAILURE		If initialization failed 
**/
DxError_t NVS_DebugStart(DxError_t        aErrorToReturn, 
                         DxUint32_t       aAccessToFail,
                         NVSDebugOpType_t aOpTypeToFail,
                         DxVosFile        aLogFileHandle);


/*!
\brief 
Stop the debug session, copy the global variable of debug to local one and 
initialize the global to zero
@param  aNvsDebugParms_ptr [in/out] variable to save global config
@return DX_SUCCESS		On success
**/
DxError_t NVS_DebugStop(NVSDebugParams_t* aNvsDebugParms_ptr);



/*!
\brief 
Get the current NVS debug parameters
@param  aNvsDebugParmsGet_ptr	[in/Out]	NVS Params struct 
@return DX_SUCCESS		On success
**/	
DxError_t NVS_DebugParamsGet(NVSDebugParams_t* aNvsDebugParmsGet_ptr);


/*!
\brief 
Cause NVS failure when <accessToFail> equal to <accessCurrent>
@param  aOpType	[in]	NVS read/write/both 
@return DX_SUCCESS		            On success
@return NVS_MEMORY_ACCESS_FAILURE   On failure
**/
DxError_t NVS_DebugOpFail(NVSDebugOpType_t aOpType);


#endif /* Define NVS_DEBUG_MODE_ENABLED */


#ifdef __cplusplus
}
#endif

#endif
